/*
 * --------------------------------------------------
 * ROR_StrictDeath.js
 *   ver.3.0.0
 * Copyright (c) 2021 R.Orio
 * This software is released under the MIT license.
 * http://opensource.org/licenses/mit-license.php
 * --------------------------------------------------
 * [version]
 * 1.0.0 初版
 * 2.0.0 ステートによる戦闘不能でもすぐにパーティーから離脱するように修正
 *       戦闘不能からパーティー離脱までのタイムラグをプラグインパラメータで調整可能に
 *       アイテム、床ダメージ及びスリップダメージでの戦闘不能に対応
 *       必須プラグインを不要化
 * 3.0.0 必須アクターが戦闘不能になった場合でも敗北メッセージを表示してから
 *       ゲームオーバーになるように変更
 */

/*:
 * @target MZ
 * @plugindesc 戦闘不能になったらパーティーから強制離脱します
 * @author R.Orio
 * @version 3.0.0
 *
 *
 * @param mainActorId
 * @text 必須アクター
 * @desc 設定したアクターが戦闘不能になると即ゲームオーバーになります。機能を使用しない場合は「なし」を選択してください。
 * @default 0
 * @type actor
 * 
 * 
 * @param mainActorDeadMessage
 * @text 必須アクター戦闘不能時のメッセージ
 * @desc 必須アクターが戦闘不能になってしまいゲームオーバーになる際のメッセージ表示を設定します。
 * @default 護衛対象が戦闘不能になってしまいました
 * @type string
 * 
 * 
 * @param timeDiff
 * @text 戦闘不能時にパーティーを離脱するまでの時差
 * @desc 戦闘不能になってからパーティーを離脱するまでの時差をミリ秒（1/1000秒）で設定します。
 * @default 500
 * @type number
 *
 *
 * @help
 * 戦闘不能になったらパーティーから強制離脱します。
 * 戦闘不能を回復するまでに離脱してしまうので難易度が上がります。
 *
 * また、「必須アクター」を設定することで、そのアクターが
 * 戦闘不能になったら即ゲームオーバーになります。
 * 
 * 必須アクターが戦闘不能になってしまったためにゲームオーバーになる場合は
 * データベースの「用語」で設定してある「敗北」メッセージとは異なり、
 * プラグインパラメータの「必須アクター戦闘不能時のメッセージ」で設定されている
 * メッセージが表示されます。通常通り「用語」で設定してある「敗北」メッセージを
 * 表示する場合はプラグインパラメータの「必須アクター戦闘不能時のメッセージ」を
 * 空欄に設定してください。
 *
 * 「戦闘不能時にパーティーを離脱するまでの時差」という設定項目で
 * 戦闘不能になった瞬間から実際にパーティーを離脱するまでの時差を設定できます。
 * 単位はミリ秒（1/1000秒）なので例えば戦闘不能になってから0.5秒後に
 * パーティーから離脱させたい場合は500で設定してください。
 * 
 * 「戦闘不能時にパーティーを離脱するまでの時差」を0にすると
 * 戦闘不能になった瞬間に離脱します。場合によってはなぜパーティーから消えたか
 * わかりづらいかもしれません。反対に5000など大きな値を設定すると、
 * 戦闘不能になってからしばらくパーティーを離脱しないため、
 * 場合によっては戦闘不能を回復する機会が生じてしまうかもしれませんので
 * 適宜調整してご使用ください。
 * 
 * ※データベース＞システム1＞オプションの「スリップダメージで戦闘不能」
 * 　及び「床ダメージで戦闘不能」を設定されている方はご注意ください。
 * 　以下のような状況で戦闘不能になった場合、発生そのものを回避できない
 * 　エラーが発生するため、エラーが発生してもゲームの進行を妨げないような
 * 　コードの記述を加えています（149行目～153行目）。
 * 　　・毒等ダメージを受ける（マイナスのHP再生率が設定された）ステートの
 * 　　　スリップダメージによりマップ画面上で戦闘不能になった場合
 * 　　・地形によるダメージによりマップ画面上で戦闘不能になった場合
 * 　　・アイテム効果により戦闘不能になった後、すぐにメニュー画面を
 * 　　　閉じたことによりパーティー離脱がマップ画面上で処理された場合
 *
 *
 * 利用規約:
 *   MITライセンスです。
 *   https://licenses.opensource.jp/MIT/MIT.html
 *   作者に無断で改変、再配布が可能で、
 *   利用形態（商用、18禁利用等）についても制限はありません。
 */

(function () {
	'use strict';

	const pluginName = document.currentScript.src.split("/").pop().replace(/\.js$/, "");

	const Parameters = PluginManager.parameters(pluginName);
	const main_actor_id = parseInt(Parameters.mainActorId);
	const time_diff = parseInt(Parameters.timeDiff);
	const main_actor_dead_message = Parameters.mainActorDeadMessage;

	const _Game_Battler_addState = Game_Battler.prototype.addState;
	Game_Battler.prototype.addState = function(stateId){
		_Game_Battler_addState.apply(this, arguments);
		removeDeadMember();
	};

	const _Game_Unit_isAllDead = Game_Unit.prototype.isAllDead;
	Game_Unit.prototype.isAllDead = function() {
		const DeadMembers = $gameParty.deadMembers();
		let is_main_actor_dead = false;
		for(const DeadMember of DeadMembers){
			if(main_actor_id > 0){
				if(DeadMember.actorId() == main_actor_id){
					is_main_actor_dead = true;
				}
			}
		}

		const check_result = this.aliveMembers().length === 0 || is_main_actor_dead;
		return check_result;
	};

	const _BattleManager_displayDefeatMessage = BattleManager.displayDefeatMessage;	
	BattleManager.displayDefeatMessage = function() {
		if($gameParty.movableMembers().length > 0 && main_actor_id > 0 && main_actor_dead_message){
			$gameMessage.add(main_actor_dead_message);
		}else{
			$gameMessage.add(TextManager.defeat.format($gameParty.name()));
		}
	};

	let actorWindowRefresh = '';
	const _Scene_ItemBase_determineItem = Scene_ItemBase.prototype.determineItem;
	Scene_ItemBase.prototype.determineItem = function(){
		_Scene_ItemBase_determineItem.apply(this, arguments);
		actorWindowRefresh = Object.assign(this._actorWindow);
	};

	//実処理
	const removeDeadMember = function(){
		const DeadMembers = $gameParty.deadMembers();
		for(const DeadMember of DeadMembers){
			if(DeadMember.actorId() !== main_actor_id){
				setTimeout(function(){
					$gameParty.removeActor(DeadMember.actorId());
					if(!$gameParty.inBattle()){
						if(actorWindowRefresh){
							try{
								actorWindowRefresh.refresh();
							}catch(error){
								console.log(error);
							}
						}
					}
				}, time_diff);
			}
		}
	};
})();