/*
 * --------------------------------------------------
 * ROR_DetectBoughtItems.js
 *   ver.1.0.0
 * Copyright (c) 2023 R.Orio
 * This software is released under the MIT license.
 * http://opensource.org/licenses/mit-license.php
 * --------------------------------------------------
 */

/*:
 * @target MZ
 * @plugindesc アイテムが購入されたかどうかを検出できます。
 * @author R.Orio
 * @version 1.0.0
 *
 * @help
 * 指定されたアイテムが購入されたかどうかをスイッチに反映します。
 * 購入された数量を変数に代入することもできます。
 * また、何も購入しなかった場合に指定のスイッチをONにすることもできます。
 *
 * 使い方:
 * プラグインパラメータで設定します。スイッチを使う場合は「スイッチ設定」で
 * 購入されたかどうかを知りたいアイテムと購入された場合にONにするスイッチを
 * 設定してください。変数を使う場合は「変数設定」で購入されたかどうかを
 * 知りたいアイテムと購入された場合に購入数を代入する変数を設定してください。
 * 設定項目は武器、防具、アイテムに分かれているので、
 * それぞれ対応する箇所に設定を入れてください。
 * 
 * 何も購入しなかった場合にスイッチをONにする場合は
 * 「冷やかしスイッチID」でONにするスイッチを設定してください。
 *
 * 利用規約:
 *   MITライセンスです。
 *   https://licenses.opensource.jp/MIT/MIT.html
 *   作者に無断で改変、再配布が可能で、
 *   利用形態（商用、18禁利用等）についても制限はありません。
 * 
 * @command endShopping
 * @text ショップの処理終了
 * @desc ショップの処理の後に挿入してください。
 *
 * 
 *
 * @param WeaponSwitchSettings
 * @text スイッチ設定（武器）
 * @type struct<WeaponCombinationSwitch>[]
 * @default []
 * 
 * @param ArmorSwitchSettings
 * @text スイッチ設定（防具）
 * @type struct<ArmorCombinationSwitch>[]
 * @default []
 * 
 * @param ItemSwitchSettings
 * @text スイッチ設定（アイテム）
 * @type struct<ItemCombinationSwitch>[]
 * @default []
 * 
 * 
 * 
 * @param WeaponVariableSettings
 * @text 変数設定（武器）
 * @type struct<WeaponCombinationVariable>[]
 * @default []
 * 
 * @param ArmorVariableSettings
 * @text 変数設定（防具）
 * @type struct<ArmorCombinationVariable>[]
 * @default []
 * 
 * @param ItemVariableSettings
 * @text 変数設定（アイテム）
 * @type struct<ItemCombinationVariable>[]
 * @default []
 * 
 * 
 * 
 * @param browser_switch_id
 * @text 冷やかしスイッチID
 * @desc 何も購入しなかった場合にONにするスイッチのIDです。
 * @type switch
 * @default 0
 */



 /*~struct~ItemCombinationSwitch:
 * @param detect_item_id
 * @text 検出するアイテムのID
 * @desc 購入されたかどうかを検出するアイテムのIDです
 * @type item
 * @default 0
 * 
 * @param reflect_switch_id
 * @text 反映スイッチID
 * @desc 購入された場合にONにするスイッチのID
 * @type switch
 * @default 0
 */



 /*~struct~ItemCombinationVariable:
 * @param detect_item_id
 * @text 検出するアイテムのID
 * @desc 購入されたかどうかを検出するアイテムのIDです
 * @type item
 * @default 0
 * 
 * @param reflect_variable_id
 * @text 反映変数ID
 * @desc 購入数を反映する変数のIDです
 * @type variable
 * @default 0
 */



 /*~struct~WeaponCombinationSwitch:
 * @param detect_weapon_id
 * @text 検出する武器のID
 * @desc 購入されたかどうかを検出する武器のIDです
 * @type weapon
 * @default 0
 * 
 * @param reflect_switch_id
 * @text 反映スイッチID
 * @desc 購入された場合にONにするスイッチのID
 * @type switch
 * @default 0
 */



 /*~struct~WeaponCombinationVariable:
 * @param detect_weapon_id
 * @text 検出する武器のID
 * @desc 購入されたかどうかを検出する武器のIDです
 * @type weapon
 * @default 0
 * 
 * @param reflect_variable_id
 * @text 反映変数ID
 * @desc 購入数を反映する変数のIDです
 * @type variable
 * @default 0
 */



 /*~struct~ArmorCombinationSwitch:
 * @param detect_armor_id
 * @text 検出する防具のID
 * @desc 購入されたかどうかを検出する防具のIDです
 * @type armor
 * @default 0
 * 
 * @param reflect_switch_id
 * @text 反映スイッチID
 * @desc 購入された場合にONにするスイッチのID
 * @type switch
 * @default 0
 */



 /*~struct~ArmorCombinationVariable:
 * @param detect_armor_id
 * @text 検出する防具のID
 * @desc 購入されたかどうかを検出する防具のIDです
 * @type armor
 * @default 0
 * 
 * @param reflect_variable_id
 * @text 反映変数ID
 * @desc 購入数を反映する変数のIDです
 * @type variable
 * @default 0
 */

(() => {
    'use strict';

    const pluginName = document.currentScript.src.split("/").pop().replace(/\.js$/, "");

    //ショップ画面起動時に購入情報を初期化
    const _Scene_Shop_prototype_initialize = Scene_Shop.prototype.initialize;
    Scene_Shop.prototype.initialize = function(){
        //ショップ画面起動時に購入情報を初期化
        $gameTemp.ROR_BoughtWeapons = [];
        $gameTemp.ROR_BoughtArmors = [];
        $gameTemp.ROR_BoughtItems = [];

        _Scene_Shop_prototype_initialize.apply(this, arguments);
    }



    //実処理
	const _Scene_Shop_doBuy = Scene_Shop.prototype.doBuy;
	Scene_Shop.prototype.doBuy = function(){
		_Scene_Shop_doBuy.apply(this, arguments);

        //購入された時のカーソル位置を取得
        const buy_index = this._buyWindow._index;

        //購入された物品の種別を取得
        const stuff_type_index = this._goods[buy_index][0];
        let stuff_type = '';
        if(stuff_type_index === 0){
            stuff_type = 'item';
        }else if(stuff_type_index === 1){
            stuff_type = 'weapon';
        }else if(stuff_type_index === 2){
            stuff_type = 'armor';
        }else{
            console.log('判定不能');
            return false;
        }

        //購入されたアイテムのIDを取得
        const stuff_id = this._item.id;

        //購入された数量を取得
        let amount = this._numberWindow._number;

        //購入前時点の購入情報を取得
        let CurrentBought = [];
        if(stuff_type === 'item'){
            CurrentBought = $gameTemp.ROR_BoughtItem;
        }else if(stuff_type === 'weapon'){
            CurrentBought = $gameTemp.ROR_BoughtWeapons;
        }else if(stuff_type === 'armor'){
            CurrentBought = $gameTemp.ROR_BoughtArmor;
        }else{
            console.log('判定不能');
            return false;
        }

        //オブジェクトを挿入する必要があるかどうかのフラグ
        let is_insert = true;

        //購入前時点の購入情報がある場合は値更新かどうかを判定
        if(CurrentBought){
            //同一アイテムの購入履歴があるかどうかを探す
            for(let Bought of CurrentBought){
                console.log(Bought.id);
                //今回購入されたアイテムが購入履歴データ内に見つかった場合
                if(Bought.id === stuff_id){
                    //購入数量を合算
                    amount += Bought.amount;
                    Bought.amount = amount;
                    //オブジェクトの挿入が不要になった
                    is_insert = false;
                }
            }
        }

        //購入履歴がない場合はオブジェクトを作成して挿入
        if(is_insert){
            const BoughtStuff = {
                id : stuff_id,
                amount : amount,
            };

            if(stuff_type === 'weapon'){
                $gameTemp.ROR_BoughtWeapons.push(BoughtStuff);
            }else if(stuff_type === 'armor'){
                $gameTemp.ROR_BoughtArmors.push(BoughtStuff);
            }else if(stuff_type === 'item'){
                $gameTemp.ROR_BoughtItems.push(BoughtStuff);
            }else{
                console.log('判定不能');
                return false;
            }
        }
    }



    const _Scene_Shop_prototype_popScene = Scene_Shop.prototype.popScene;
    Scene_Shop.prototype.popScene = function(){

        //検出したいアイテムと設定情報を取得
        const Parameters = PluginManager.parameters(pluginName);
        const WeaponSwitchSettings = JSON.parse(Parameters.WeaponSwitchSettings);
        const ArmorSwitchSettings = JSON.parse(Parameters.ArmorSwitchSettings);
        const ItemSwitchSettings = JSON.parse(Parameters.ItemSwitchSettings);
        const WeaponVariableSettings = JSON.parse(Parameters.WeaponVariableSettings);
        const ArmorVariableSettings = JSON.parse(Parameters.ArmorVariableSettings);
        const ItemVariableSettings = JSON.parse(Parameters.ItemVariableSettings);

		//スイッチ初期化（一旦設定されているスイッチを全てOFFにする）
        for(let WeaponSwitchSetting of WeaponSwitchSettings){
			const WeaponSwitchSettingInfo = JSON.parse(WeaponSwitchSetting);
			$gameSwitches.setValue(parseInt(WeaponSwitchSettingInfo.reflect_switch_id), false);
        }

        for(let ArmorSwitchSetting of ArmorSwitchSettings){
			const ArmorSwitchSettingInfo = JSON.parse(ArmorSwitchSetting);
			$gameSwitches.setValue(parseInt(ArmorSwitchSettingInfo.reflect_switch_id), false);
        }

        for(let ItemSwitchSetting of ItemSwitchSettings){
			const ItemSwitchSettingInfo = JSON.parse(ItemSwitchSetting);
			$gameSwitches.setValue(parseInt(ItemSwitchSettingInfo.reflect_switch_id), false);
        }

		//変数初期化（一旦設定されている変数を0にする）
		for(let WeaponVariableSetting of WeaponVariableSettings){
			const WeaponVariableSettingInfo = JSON.parse(WeaponVariableSetting);
			$gameVariables.setValue(parseInt(WeaponVariableSettingInfo.reflect_variable_id), 0);
        }

		for(let ArmorVariableSetting of ArmorVariableSettings){
			const ArmorVariableSettingInfo = JSON.parse(ArmorVariableSetting);
			$gameVariables.setValue(parseInt(ArmorVariableSettingInfo.reflect_variable_id), 0);
        }

		for(let ItemVariableSetting of ItemVariableSettings){
			const ItemVariableSettingInfo = JSON.parse(ItemVariableSetting);
			$gameVariables.setValue(parseInt(ItemVariableSettingInfo.reflect_variable_id), 0);
        }

		//スイッチ側処理
        for(let WeaponSwitchSetting of WeaponSwitchSettings){
            for(let BoughtWeapon of $gameTemp.ROR_BoughtWeapons){
                const WeaponSwitchSettingInfo = JSON.parse(WeaponSwitchSetting);
                const detect_weapon_id = parseInt(WeaponSwitchSettingInfo.detect_weapon_id);
                if(BoughtWeapon.id === detect_weapon_id){
                    //検出対象の武器が購入されていた場合は指定されたスイッチをONにする
                    const reflect_switch_id = parseInt(WeaponSwitchSettingInfo.reflect_switch_id);
                    $gameSwitches.setValue(reflect_switch_id, true);
                }
            }
        }

        for(let ArmorSwitchSetting of ArmorSwitchSettings){
            for(let BoughtArmor of $gameTemp.ROR_BoughtArmors){
                const ArmorSwitchSettingInfo = JSON.parse(ArmorSwitchSetting);
                const detect_armor_id = parseInt(ArmorSwitchSettingInfo.detect_armor_id);
                if(BoughtArmor.id === detect_armor_id){
                    //検出対象の防具が購入されていた場合は指定されたスイッチをONにする
                    const reflect_switch_id = parseInt(ArmorSwitchSettingInfo.reflect_switch_id);
                    $gameSwitches.setValue(reflect_switch_id, true);
                }
            }
        }

        for(let ItemSwitchSetting of ItemSwitchSettings){
            for(let BoughtItem of $gameTemp.ROR_BoughtItems){
                const ItemSwitchSettingInfo = JSON.parse(ItemSwitchSetting);
                const detect_item_id = parseInt(ItemSwitchSettingInfo.detect_item_id);
                if(BoughtItem.id === detect_item_id){
                    //検出対象のアイテムが購入されていた場合は指定されたスイッチをONにする
                    const reflect_switch_id = parseInt(ItemSwitchSettingInfo.reflect_switch_id);
                    $gameSwitches.setValue(reflect_switch_id, true);
                }
            }
        }

        //変数側処理
        for(let WeaponVariableSetting of WeaponVariableSettings){
            for(let BoughtWeapon of $gameTemp.ROR_BoughtWeapons){
                const WeaponVariableSettingInfo = JSON.parse(WeaponVariableSetting);
                const detect_weapon_id = parseInt(WeaponVariableSettingInfo.detect_weapon_id);
                if(BoughtWeapon.id === detect_weapon_id){
                    //検出対象のアイテムが購入されていた場合は指定された変数に購入数を代入する
                    const reflect_variable_id = parseInt(WeaponVariableSettingInfo.reflect_variable_id);
                    $gameVariables.setValue(reflect_variable_id, BoughtWeapon.amount);
                }
            }
        }

        for(let ArmorVariableSetting of ArmorVariableSettings){
            for(let BoughtArmor of $gameTemp.ROR_BoughtArmors){
                const ArmorVariableSettingInfo = JSON.parse(ArmorVariableSetting);
                const detect_armor_id = parseInt(ArmorVariableSettingInfo.detect_armor_id);
                if(BoughtArmor.id === detect_armor_id){
                    //検出対象のアイテムが購入されていた場合は指定された変数に購入数を代入する
                    const reflect_variable_id = parseInt(ArmorVariableSettingInfo.reflect_variable_id);
                    $gameVariables.setValue(reflect_variable_id, BoughtArmor.amount);
                }
            }
        }

        for(let ItemVariableSetting of ItemVariableSettings){
            for(let BoughtItem of $gameTemp.ROR_BoughtItems){
                const ItemVariableSettingInfo = JSON.parse(ItemVariableSetting);
                const detect_item_id = parseInt(ItemVariableSettingInfo.detect_item_id);
                if(BoughtItem.id === detect_item_id){
                    //検出対象のアイテムが購入されていた場合は指定された変数に購入数を代入する
                    const reflect_variable_id = parseInt(ItemVariableSettingInfo.reflect_variable_id);
                    $gameVariables.setValue(reflect_variable_id, BoughtItem.amount);
                }
            }
        }

        //冷やかしチェック
        const browser_switch_id = parseInt(Parameters.browser_switch_id);
        if(browser_switch_id){
            if($gameTemp.ROR_BoughtWeapons.length === 0 && $gameTemp.ROR_BoughtArmors.length === 0 && $gameTemp.ROR_BoughtItems.length === 0){
                $gameSwitches.setValue(browser_switch_id, true);
            }else{
                $gameSwitches.setValue(browser_switch_id, false);
            }
        }

        _Scene_Shop_prototype_popScene.apply(this, arguments);
    };
})();