/*
 * --------------------------------------------------
 * ROR_StrictDeath.js
 *   ver.1.0.0
 * Copyright (c) 2021 R.Orio
 * This software is released under the MIT license.
 * http://opensource.org/licenses/mit-license.php
 * --------------------------------------------------
 */

/*:
 * @target MZ
 * @plugindesc 戦闘不能になったらパーティーから強制離脱します
 * @author R.Orio
 * @version 1.0.0

 * @help
 * 戦闘不能になったらパーティーから強制離脱します。
 * 戦闘不能を回復するまでに離脱してしまうので難易度が上がります。
 *
 * 利用規約:
 *   MITライセンスです。
 *   https://licenses.opensource.jp/MIT/MIT.html
 *   作者に無断で改変、再配布が可能で、
 *   利用形態（商用、18禁利用等）についても制限はありません。
 *
 */

(function () {
	'use strict';

	function executeRemoveDeadMembers() {
		const upstream_Game_Battler_regenerateHp = Game_Battler.prototype.regenerateHp;
		Game_Battler.prototype.regenerateHp = function () {
			let deadMembers = $gameParty.deadMembers();
			deadMembers.forEach(function(Actor){
				console.log(Actor._actorId);
				if(parseInt(Actor._actorId) == 2){
					console.log('ここに強制ゲームオーバー処理を入れたい');
				}
				$gameParty.removeActor(Actor._actorId);
			});
			upstream_Game_Battler_regenerateHp.apply(this);
		};
	}

	executeRemoveDeadMembers();

})();